﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.OData;
using System.Web.OData.Routing;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Messages;
using Microsoft.Xrm.Sdk.Query;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;
using System.Net;
using System.Net.Http;
using Microsoft.Web.Http;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class ProviderContactsController : ODataController
    {
        [ODataRoute("ProviderContacts('{key}')")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            //This Scenario matches finds provider contact based on name. 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                string nameMatch = key.ToString();
                var ppmsProviderContact = context.ContactSet.FirstOrDefault(i => i.FullName.Contains(nameMatch));
                if (ppmsProviderContact !=null)
                {
                    //Map Provider Contacts
                    var ppmsProviderContactsList = new List<Contact> { ppmsProviderContact };
                    var providerContact =
                        await ProviderContactsMap.MapProviderContacts(ppmsProviderContactsList, queryType, context);
                    return Request.CreateResponse(providerContact);
                }
            }
            var message = string.Format("Provider Contacts with Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        //Returns only the Contacts related Provider    
        [ODataRoute("ProviderContacts('{key}')/Provider")]
        public async Task<HttpResponseMessage> GetProvider([FromODataUri] int key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            //This Scenario matches finds provider contact based on name. 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                string nameMatch = key.ToString();
                var ppmsProviderContact = context.ContactSet.FirstOrDefault(i => i.FullName.Contains(nameMatch));
                if (ppmsProviderContact != null)
                {
                    //Retrieve and Return the related Provider record. 
                    var ppmsProviders =
                        context.AccountSet.Where(i => i.Id == ppmsProviderContact.ParentCustomerId.Id);
                    var ppmsProvidersList = ppmsProviders.ToList();
                    var provider =
                        await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                    return Request.CreateResponse(provider);
                }
            }
            var message = string.Format("Provider with Provider Contacts Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        //Returns only the Contacts related Provider    
        [ODataRoute("ProviderContacts('{key}')/CareSites")]
        public async Task<HttpResponseMessage> GetCareSites([FromODataUri] int key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            //This Scenario matches finds provider contact based on name. 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                string nameMatch = key.ToString();
                var ppmsProviderContact = context.ContactSet.FirstOrDefault(i => i.FullName.Contains(nameMatch));
                if (ppmsProviderContact != null)
                {
                    //Retrieve and Retrun the realted Provider record. 
                    //Lookup and Map the Care Sites
                    var ppmsCareSites =
                        context.ppms_caresiteSet.Where(i => i.ppms_SiteContact.Id == ppmsProviderContact.Id);
                    var ppmsCareSitesList = ppmsCareSites.ToList();
                    var careSites =
                        await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                    return Request.CreateResponse(careSites);
                }
            }
            var message = string.Format("Care Sites with Provider Contact Name: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderContacts")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Providers in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderContacts =
                    context.ContactSet.Where(i => i.ParentCustomerId != null).Take(50);
                var ppmsProviderContactsList = ppmsProviderContacts.ToList();
                if (ppmsProviderContactsList.Any())
                {
                    //Map Providers Contacts
                    var providerContacts = await ProviderContactsMap.MapProviderContacts(ppmsProviderContactsList, "None", context);
                    return Request.CreateResponse(providerContacts);
                }
                var message = "Provider Contacts Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
           // return Request.CreateResponse(PpmsDataSources.Instance.ProviderCredentials.AsQueryable());
        }       
    }
}